
Type Demo12Screen Extends TScreen
	
	Field border:TBorder
	Field agent:TAgent
	Field fluid:TFluidDragController
	Field body1:TBody
	Field body2:TBody
	Field body3:TBody
	Field geom1:TGeom
	Field geom2:TGeom
	Field geom3:TGeom	
	Field tex:TImage
	Field water:TWaterContainer
	Field boxTex:TImage
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
			_firstRun = False
		EndIf
	
		HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	Method Draw(delta:Float)
		border.Draw()
		agent.Draw()
		TDrawingHelper.DrawGeom(geom1, tex)
		TDrawingHelper.DrawGeom(geom2, tex)
		TDrawingHelper.DrawGeom(geom3, boxTex)
		water.Draw()
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 200))
		view = TPhysicsSimulatorView.Create(physics)
		
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		Local borderWidth:Int = TDemo.gfxHeight *.05
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)

		agent = TAgent.Create(Vector2.Create(center.X-200, 100))
		agent.SetCollidesWith(CollisionCategories.All)
		agent.Load(physics)
		
		Local bwidth:Int = 70
		Local bHeight:Int = 20
		Local boxWidth:Int = 80
		Local boxHeight:Int = 80
		
		tex = TDrawingHelper.CreateRectangleTexture(bWidth, bHeight, TColor.White, TColor.Black)
		boxTex = TDrawingHelper.CreateRectangleTexture(boxWIdth, boxheight, TColor.White, TColor.Black)
		MidHandleImage(boxTex)
		MidHandleImage(tex)
		body1 = TBodyFactory.CreateRectangleBody(physics, bWidth, bHeight, 10)
		body2 = TBodyFactory.CloneBody(physics, body1)
		body1.SetPosition(Vector2.Create(center.X + 200, center.Y))
		body2.SetPosition(Vector2.Create(center.X - 200, center.Y))
		body3 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 10)
		body3.SetPosition(center)
		
		geom1 = TGeomFactory.CreateRectangleGeom(physics, body1, bWidth, bHeight)
		geom2 = TGeomFactory.CloneGeom(physics, body2, geom1)
		geom3 = TGeomFactory.CreateRectangleGeom(physics, body3, boxWidth, boxHeight)
		
		water = TWaterContainer.Create(physics, Vector2.Create(borderWidth, 400), Vector2.Create(TDemo.gfxWidth - borderWidth * 2, TDemo.gfxHeight - 400 - borderWidth), Vector2.Create(0, 200), 200)
		water.AddGeom(geom1)
		water.AddGeom(geom2)
		water.AddGeom(geom3)
		For Local g:TGeom = EachIn agent.agentGeom
			water.AddGeom(g)
			g._body.SetMass(15)
		Next

	End Method
	

	Method Unload()
		
	End Method
	
	Method HandleKeyboardInput()
		Local forceAmount:Float = 3000
		Local force:Vector2 = Vector2.Zero()
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method
	
	Method GetTitle:String()
		Return "Fluid Drag Controllers"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows a Fluid Drag Controller that simulates the")
		sb.AppendLine("buoyancy and under water drag forces on the physical bodies.")
		sb.AppendLine("This demo also has a wave controller that simulates the formation")
		sb.AppendLine("of 2D waves at the surface of a fluid container.")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag") 
		Return sb
	End Method
End Type
